use utf8;
#Encodeモジュールをインポート
use Encode qw/encode decode/;
use File::Basename qw/basename dirname/;

$_ = $ARGV[0];
$_ = decode('UTF-8', $_);

#指定フォルダを開く
opendir(DIRHANDLE, "$_");
my @allFileList;
foreach $file(readdir(DIRHANDLE)){
	unless ($file =~ /^(.*?)\.(png|jpg|jpeg|gif|svg)$/){next;};
	push @allFileList, $file;
}
#親フォルダ名を取得
my $parentDirName = basename $_;

#指定フォルダを閉じる
closedir(DIRHANDLE);

#ソート処理
@allFileList = sort {$b <=> $a} @allFileList;

#中間出力テキストリスト定義
my @coverImageList;
my @whiteImageList;
my @honbunImageList;
my @colophonImageList;
my @creditImageList;
my @adImageList;
my @normalImageList;

#最終出力テキストリスト定義
my @finalImageManifestList;

#各項目ごとに分類
for (1..scalar(@allFileList)){
	$myListFile = pop(@allFileList);
	if ($myListFile =~ /^cover\.(jpg|jpeg|png|gif)$/){unshift (@coverImageList,$myListFile);
	} elsif ($myListFile =~ /^i-white-?([0-9]+)?\.(jpg|jpeg|png|gif)$/){unshift (@whiteImageList,$myListFile);
	} elsif ($myListFile =~ /^i-[0-9]+\.(jpg|jpeg|png|gif)$/){unshift (@honbunImageList,$myListFile);
	} elsif ($myListFile =~ /^i-colophon\.(jpg|jpeg|png|gif)$/){unshift (@colophonImageList,$myListFile);
	} elsif ($myListFile =~ /^i-ad-[0-9]+\.(jpg|jpeg|png|gif)$/){unshift (@adImageList,$myListFile);
	} elsif ($myListFile =~ /^i-credit\.(jpg|jpeg|png|gif)$/){unshift (@creditImageList,$myListFile);
	} else {unshift (@normalImageList,$myListFile);
	}
	}
	
	#cover（カバー）イメージの置換処理
	foreach $myListFile(@coverImageList){
		$myListFile =~ s@^cover\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$1\" id=\"cover\" href=\"$parentDirName/cover\.$1\" properties=\"cover-image\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	#白ページイメージの置換処理
	foreach $myListFile(@whiteImageList){
		$myListFile =~ s@^(i-white-?([0-9]+)?)\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$3\" id=\"$1\" href=\"$parentDirName/$1\.$3\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	#本文ページイメージの置換処理
	foreach $myListFile(@honbunImageList){
		$myListFile =~ s@^i-([0-9]+)?\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$2\" id=\"i-$1\" href=\"$parentDirName/i-$1\.$2\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	#原本奥付イメージの置換処理
	foreach $myListFile(@colophonImageList){
		$myListFile =~ s@^i-colophon?\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$1\" id=\"i-colophon\" href=\"$parentDirName/i-colophon\.$1\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	#広告ページイメージの置換処理
	foreach $myListFile(@adImageList){
		$myListFile =~ s@^(i-ad-[0-9]+)\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$2\" id=\"$1\" href=\"$parentDirName/$1\.$2\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	#電子化奥付イメージの置換処理
	foreach $myListFile(@creditImageList){
		$myListFile =~ s@^i-credit?\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$1\" id=\"i-credit\" href=\"$parentDirName/i-credit\.$1\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	#その他イメージの置換処理
	foreach $myListFile(@normalImageList){
		$myListFile =~ s@^(.*?)\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$2\" id=\"$1\" href=\"$parentDirName/$1\.$2\" />@i;
		$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
		push (@finalImageManifestList,$myListFile);
	}
	
	
	#@finalImageManifestListを改行コード入り文字列に
	my $finalImageManifestText = join("\n",@finalImageManifestList);
	
	#出力
	print $finalImageManifestText;