use utf8;
#Encodeモジュールをインポート
use Encode qw/encode decode/;
use File::Basename qw/basename dirname/;

$_ = $ARGV[0];
$_ = decode('UTF-8', $_);

#指定フォルダを開く
opendir(DIRHANDLE, "$_");
my @allFileList;
foreach $file(readdir(DIRHANDLE)){
	unless ($file =~ /^(.*?)\.(png|jpg|jpeg|gif|svg)$/){next;};
	push @allFileList, $file;
}
#親フォルダ名を取得
my $parentDirName = basename $_;

#指定フォルダを閉じる
closedir(DIRHANDLE);

#ソート処理
@allFileList = sort {$b <=> $a} @allFileList;

#中間出力テキストリスト定義
my @coverImageList;
my @normalImageList;
my @creditImageList;
my @gaijiImageList;

#最終出力テキストリスト定義
my @finalImageManifestList;

#各項目ごとに分類
for (1..scalar(@allFileList)){
	$myListFile = pop(@allFileList);
	if ($myListFile =~ /^cover\.(jpg|jpeg|png|gif)$/){unshift (@coverImageList,$myListFile);
	} elsif ($myListFile =~ /^original_credit\.(jpg|jpeg|png|gif)$/){unshift (@creditImageList,$myListFile);
	} elsif ($myListFile =~ /^(cid-[0-9]+)\.png$/){unshift (@gaijiImageList,$myListFile);
	} else {unshift (@normalImageList,$myListFile);
	}
	}

#cover（カバー）イメージの置換処理
foreach $myListFile(@coverImageList){
	$myListFile =~ s@^cover\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$1\" id=\"cover\" href=\"$parentDirName/cover\.$1\" properties=\"cover-image\" />@i;
	$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
	push (@finalImageManifestList,$myListFile);
}
#通常イメージの置換処理
foreach $myListFile(@normalImageList){
	$myListFile =~ s@^(.*?)\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$2\" id=\"$1\" href=\"$parentDirName/$1\.$2\" />@i;
	$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
	push (@finalImageManifestList,$myListFile);
}
#クレジットイメージの置換処理
foreach $myListFile(@creditImageList){
	$myListFile =~ s@^original_credit\.(jpg|jpeg|png|gif)$@<item media-type=\"image/$1\" id=\"credit\" href=\"$parentDirName/original_credit\.$1\" />@i;
	$myListFile =~ s@media-type=\"image/jpg\"@media-type=\"image/jpeg\"@i;
	push (@finalImageManifestList,$myListFile);
}
#外字イメージの置換処理
foreach $myListFile(@gaijiImageList){
	$myListFile =~ s@^cid-([0-9]+)\.(png|gif)$@<item media-type=\"image/$2\" id=\"cid$1\" href=\"$parentDirName/cid-$1\.$2\" />@i;
	push (@finalImageManifestList,$myListFile);
}

#@finalImageManifestListを改行コード入り文字列に
my $finalImageManifestText = join("\n",@finalImageManifestList);

#出力
print $finalImageManifestText;