use utf8;
#Encodeモジュールをインポート
use Encode qw/encode decode/;

$_ = $ARGV[0];
$pageDirection = $ARGV[1];
$_ = decode('UTF-8', $_);
$pageDirection = decode('UTF-8', $pageDirection);

#指定フォルダを開く
opendir(DIRHANDLE, "$_");
my @allFileList;
foreach $file(readdir(DIRHANDLE)){
	unless ($file =~ /^(.*?)\.xhtml$/){next;};
	push @allFileList, $file;
}

#指定フォルダを閉じる
closedir(DIRHANDLE);

#ソート処理
@allFileList = sort {$b <=> $a} @allFileList;

#pagedirection設定
if ($pageDirection eq "rtl"){$pageSpread = "page-spread-left";
} elsif ($pageDirection eq "ltr"){$pageSpread = "page-spread-right";
	}


#中間出力テキストリスト定義
my @pCoverList;
my @pFmatterList;
my @pTitlePageList;
my @pCautionList;
my @pTocList;
my @pHonbunList;
my @pColophonList;
my @pAdList;
my @pCreditList;
my @otherList;

#最終出力テキストリスト定義
my @finalSpineList;

#各項目ごとに分類
for (1..scalar(@allFileList)){
	$myListFile = pop(@allFileList);
	if ($myListFile =~ /^p-cover\.xhtml$/){unshift (@pCoverList,$myListFile);
	} elsif ($myListFile =~ /^p-fmatter-[0-9]+\.xhtml$/){unshift (@pFmatterList,$myListFile);
	} elsif ($myListFile =~ /^p-titlepage\.xhtml$/){unshift (@pTitlePageList,$myListFile);
	} elsif ($myListFile =~ /^p-caution\.xhtml$/){unshift (@pCautionList,$myListFile);
	} elsif ($myListFile =~ /^p-toc\.xhtml$/){unshift (@pTocList,$myListFile);		
	} elsif ($myListFile =~ /^p-[0-9]+\.xhtml$/){unshift (@pHonbunList,$myListFile);
	} elsif ($myListFile =~ /^p-colophon\.xhtml$/){unshift (@pColophonList,$myListFile);
	} elsif ($myListFile =~ /^p-ad-[0-9]+\.xhtml$/){unshift (@pAdList,$myListFile);
	} elsif ($myListFile =~ /^p-credit\.xhtml$/){unshift (@pCreditList,$myListFile);
	} else {unshift (@otherList,$myListFile);
	}
}
	
#p-cover（カバー）ページの置換処理
foreach $myListFile(@pCoverList){
	$myListFile =~ s@^p-cover\.xhtml$@<itemref linear=\"yes\" idref=\"p-cover\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-fmatter-xxx（前付）ページの置換処理
foreach $myListFile(@pFmatterList){
	$myListFile =~ s@^(p-fmatter-[0-9]+)\.xhtml$@<itemref linear=\"yes\" idref=\"$1\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-titlepage（本扉）ページの置換処理
foreach $myListFile(@pTitlePageList){
	$myListFile =~ s@^p-titlepage\.xhtml$@<itemref linear=\"yes\" idref=\"p-titlepage\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-caution（電子化注意書き）ページの置換処理
foreach $myListFile(@pCautionList){
	$myListFile =~ s@^p-caution\.xhtml$@<itemref linear=\"yes\" idref=\"p-caution\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-toc（目次）ページの置換処理
foreach $myListFile(@pTocList){
	$myListFile =~ s@^p-toc\.xhtml$@<itemref linear=\"yes\" idref=\"p-toc\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-xxx（本文）ページの置換処理
foreach $myListFile(@pHonbunList){
	$myListFile =~ s@^(p-[0-9]+)\.xhtml$@<itemref linear=\"yes\" idref=\"$1\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-colophon（原本奥付）ページの置換処理
foreach $myListFile(@pColophonList){
	$myListFile =~ s@^p-colophon\.xhtml$@<itemref linear=\"yes\" idref=\"p-colophon\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-ad-xxx（広告）ページの置換処理
foreach $myListFile(@pAdList){
	$myListFile =~ s@^(p-ad-[0-9]+)\.xhtml$@<itemref linear=\"yes\" idref=\"$1\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#p-credit（電子化奥付）ページの置換処理
foreach $myListFile(@pCreditList){
	$myListFile =~ s@^p-credit\.xhtml$@<itemref linear=\"yes\" idref=\"p-credit\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}
#それ以外のページの置換処理
foreach $myListFile(@otherList){
	$myListFile =~ s@^(.*?)\.xhtml$@<itemref linear=\"yes\" idref=\"$1\" properties=\"$pageSpread\" />@i;
	push (@finalSpineList,$myListFile);
}

#@finalSpineListを改行コード入り文字列に
my $finalSpineText = join("\n",@finalSpineList);

#spineタグの最終合成
my $finalSpineText = '<spine page-progression-direction="' . $pageDirection . '">' . "\n" . "\n" . $finalSpineText . "\n" . "\n" . '</spine>';

#出力
print $finalSpineText;