use utf8;
#Encodeモジュールをインポート
use Encode qw/encode decode/;

$openFolderPath = $ARGV[0];
$bookTitleName = $ARGV[1];
$myTxtDirection = $ARGV[2];
$openFolderPath = decode('UTF-8', $openFolderPath);
$bookTitleName = decode('UTF-8', $bookTitleName);
$myTxtDirection = decode('UTF-8', $myTxtDirection);

#指定フォルダを開く
opendir(DIRHANDLE, "$openFolderPath");
my @allFileList;
#xhtmlファイルのみをリストとして取得
foreach $file(readdir(DIRHANDLE)){
	unless ($file =~ /^(.*?)\.xhtml$/){next;};
	push @allFileList, $file;
}

#指定フォルダを閉じる
closedir(DIRHANDLE);

#ソート処理
@allFileList = sort {$a <=> $b} @allFileList;

#中間出力テキストリスト定義
my @pCoverList;
my @pFmatterList;
my @pTitlePageList;
my @pCautionList;
my @pTocList;
my @pHonbunList;
my @pColophonList;
my @pAdList;
my @pCreditList;
my @otherList;

#各項目ごとに分類
for (1..scalar(@allFileList)){
	$myListFile = pop(@allFileList);
	if ($myListFile =~ /^p-cover\.xhtml$/){push (@pCoverList,$myListFile);
	} elsif ($myListFile =~ /^p-fmatter-[0-9]+\.xhtml$/){push (@pFmatterList,$myListFile);
	} elsif ($myListFile =~ /^p-titlepage\.xhtml$/){push (@pTitlePageList,$myListFile);
	} elsif ($myListFile =~ /^p-caution\.xhtml$/){push (@pCautionList,$myListFile);
	} elsif ($myListFile =~ /^p-toc\.xhtml$/){push (@pTocList,$myListFile);		
	} elsif ($myListFile =~ /^p-[0-9]+\.xhtml$/){push (@pHonbunList,$myListFile);
	} elsif ($myListFile =~ /^p-colophon\.xhtml$/){push (@pColophonList,$myListFile);
	} elsif ($myListFile =~ /^p-ad-[0-9]+\.xhtml$/){push (@pAdList,$myListFile);
	} elsif ($myListFile =~ /^p-credit\.xhtml$/){push (@pCreditList,$myListFile);
	} else {push (@otherList,$myListFile);
	}
}
#ソート後の処理ファイルリスト再合体（@myOpenFileListに押し込む）
my @myOpenFileList;
foreach $myFileName(@pCoverList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@pFmatterList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@pTitlePageList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@pCautionList){unshift (@myOpenFileList,$myFileName);}
unshift @myOpenFileList,"p-toc\.xhtml";
foreach $myFileName(@pHonbunList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@pColophonList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@pAdList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@pCreditList){unshift (@myOpenFileList,$myFileName);}
foreach $myFileName(@otherList){unshift (@myOpenFileList,$myFileName);}

#タグ置換後の目次最終出力リストの定義
my @FinalTocTextList;

#全ファイルを順番に開くためのパス合成
foreach $myOpenFile (@myOpenFileList){
	my $myFilePath = $openFolderPath . $myOpenFile;
	
	#ファイルを開く
	open(IN,"$myFilePath");
	chomp(@mytxts = <IN>);
	close (IN);
	
	#目次へのリンク指定を探し、発見したら最終出力リストに書き込む
	foreach $myReplaceTxt (@mytxts){
		#tobira-midashiの処理
		$myReplaceTxt = decode('UTF-8', $myReplaceTxt);
		if ($myReplaceTxt =~ /<h1 ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h1>/){
			$myReplaceTxt =~ s@<h1 ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h1>@<p><a href=\"$myOpenFile\#$3\">$7</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h1 ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)>(.*?)<\/h1>/){
			$myReplaceTxt =~ s@<h1 ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)>(.*?)</h1>@<p><a href=\"$myOpenFile\#$3\">$5</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h1 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h1>/){
			$myReplaceTxt =~ s@<h1 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h1>@<p><a href=\"$myOpenFile\#$2\">$7</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h1 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)>(.*?)<\/h1>/){
			$myReplaceTxt =~ s@<h1 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)>(.*?)</h1>@<p><a href=\"$myOpenFile\#$2\">$5</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<p ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/p>/){
			$myReplaceTxt =~ s@<p ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></p>@<p><a href=\"$myOpenFile\#$3\">$7</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<p ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)>(.*?)<\/p>/){
			$myReplaceTxt =~ s@<p ([^<>]*?)class=\"tobira-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)>(.*?)</p>@<p><a href=\"$myOpenFile\#$3\">$5</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<p ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/p>/){
			$myReplaceTxt =~ s@<p ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></p>@<p><a href=\"$myOpenFile\#$2\">$7</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<p ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)>(.*?)<\/p>/){
			$myReplaceTxt =~ s@<p ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"tobira-midashi\"([^<>]*?)>(.*?)</p>@<p><a href=\"$myOpenFile\#$2\">$5</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		
		
		#画像扱いの章扉見出しの処理
		if ($myReplaceTxt =~ /<p><img([^<>]*?)\" alt=\"([^<>]*?)\" id=\"([^<>]+?)\"([^<>]*?)\/><\/p>/){
			$myReplaceTxt =~ s@<p><img([^<>]*?)\" alt=\"([^<>]*?)\" id=\"([^<>]+?)\"([^<>]*?)\/><\/p>@<p><a href=\"$myOpenFile\#$3\">$2</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<p><img([^<>]*?)\" id=\"([^<>]+?)\" alt=\"([^<>]*?)\"([^<>]*?)\/><\/p>/){
			$myReplaceTxt =~ s@<p><img([^<>]*?)\" id=\"([^<>]+?)\" alt=\"([^<>]*?)\"([^<>]*?)\/><\/p>@<p><a href=\"$myOpenFile\#$2\">$3</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		
		#oo-midashiの処理
		if ($myReplaceTxt =~ /<h2 ([^<>]*?)class=\"oo-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h2>/){
			$myReplaceTxt =~ s@<h2 ([^<>]*?)class=\"oo-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h2>@<p><a href=\"$myOpenFile\#$3\">$7</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h2 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"oo-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h2>/){
			$myReplaceTxt =~ s@<h2 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"oo-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h2>@<p><a href=\"$myOpenFile\#$2\">$7</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h2 ([^<>]*?)class=\"oo-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)>(.*?)<\/h2>/){
			$myReplaceTxt =~ s@<h2 ([^<>]*?)class=\"oo-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)>(.*?)</h2>@<p><a href=\"$myOpenFile\#$3\">$5</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h2 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"oo-midashi\"([^<>]*?)>(.*?)<\/h2>/){
			$myReplaceTxt =~ s@<h2 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"oo-midashi\"([^<>]*?)>(.*?)</h2>@<p><a href=\"$myOpenFile\#$2\">$5</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		
		#naka-midashiの処理
		if ($myReplaceTxt =~ /<h3 ([^<>]*?)class=\"naka-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h3>/){
			$myReplaceTxt =~ s@<h3 ([^<>]*?)class=\"naka-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h3>@<p class=\"start-1em\"><a href=\"$myOpenFile\#$3\">$7</a></p>@ig;
			#底本奥付の行のみ字下げなし
			$myReplaceTxt =~ s@<p class=\"start-1em\"><a href=\"([^<]*?)\.xhtml\#([^<]*?)\">底本奥付</a></p>@<p><a href=\"$1\.xhtml\#$2\">底本奥付</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h3 ([^<>]*?)class=\"naka-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)>(.*?)<\/h3>/){
			$myReplaceTxt =~ s@<h3 ([^<>]*?)class=\"naka-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)>(.*?)</h3>@<p class=\"start-1em\"><a href=\"$myOpenFile\#$3\">$5</a></p>@ig;
			#底本奥付の行のみ字下げなし
			$myReplaceTxt =~ s@<p class=\"start-1em\"><a href=\"([^<]*?)\.xhtml\#([^<]*?)\">底本奥付</a></p>@<p><a href=\"$1\.xhtml\#$2\">底本奥付</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h3 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"naka-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h3>/){
			$myReplaceTxt =~ s@<h3 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"naka-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h3>@<p class=\"start-1em\"><a href=\"$myOpenFile\#$2\">$7</a></p>@ig;
			#底本奥付の行のみ字下げなし
			$myReplaceTxt =~ s@<p class=\"start-1em\"><a href=\"([^<]*?)\.xhtml\#([^<]*?)\">底本奥付</a></p>@<p><a href=\"$1\.xhtml\#$2\">底本奥付</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h3 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"naka-midashi\"([^<>]*?)>(.*?)<\/h3>/){
			$myReplaceTxt =~ s@<h3 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"naka-midashi\"([^<>]*?)>(.*?)</h3>@<p class=\"start-1em\"><a href=\"$myOpenFile\#$2\">$5</a></p>@ig;
			#底本奥付の行のみ字下げなし
			$myReplaceTxt =~ s@<p class=\"start-1em\"><a href=\"([^<]*?)\.xhtml\#([^<]*?)\">底本奥付</a></p>@<p><a href=\"$1\.xhtml\#$2\">底本奥付</a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		
		#ko-midashiの処理
		if ($myReplaceTxt =~ /<h4 ([^<>]*?)class=\"ko-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h4>/){
			$myReplaceTxt =~ s@<h4 ([^<>]*?)class=\"ko-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)</a></h4>@<p class=\"start-2em\"><a href=\"$myOpenFile\#$3\"><span class=\"font-0em80\">$7</span></a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h4 ([^<>]*?)class=\"ko-midashi\"([^<>]*?) id=\"[^<]+?\"([^<>]*?)>(.*?)<\/h4>/){
			$myReplaceTxt =~ s@<h4 ([^<>]*?)class=\"ko-midashi\"([^<>]*?) id=\"([^<]+?)\"([^<>]*?)>(.*?)</h4>@<p class=\"start-2em\"><a href=\"$myOpenFile\#$3\"><span class=\"font-0em80\">$5</span></a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h4 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"ko-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a><\/h4>/){
			$myReplaceTxt =~ s@<h4 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"ko-midashi\"([^<>]*?)><a ([^<>]*?)href=\"p-toc\.xhtml\"([^<>]*?)>(.*?)<\/a></h4>@<p class=\"start-2em\"><a href=\"$myOpenFile\#$2\"><span class=\"font-0em80\">$7</span></a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		if ($myReplaceTxt =~ /<h4 ([^<>]*?)id=\"[^<]+?\"([^<>]*?) class=\"ko-midashi\"([^<>]*?)>(.*?)<\/h4>/){
			$myReplaceTxt =~ s@<h4 ([^<>]*?)id=\"([^<]+?)\"([^<>]*?) class=\"ko-midashi\"([^<>]*?)>(.*?)</h4>@<p class=\"start-2em\"><a href=\"$myOpenFile\#$2\"><span class=\"font-0em80\">$5</span></a></p>@ig;
			push (@FinalTocTextList,$myReplaceTxt);
		}
		
	}
}

#@finalXhtmlManifestList;を改行コード入り文字列に
my $finalTocText = join("\n",@FinalTocTextList);


#ヘッダ等を合成
$finalTocText = "<?xml version=\"1\.0\" encoding=\"utf-8\"\?>\n<\!DOCTYPE html>\n<html xmlns=\"http://www\.w3\.org/1999/xhtml\" xmlns:epub=\"http://www\.idpf\.org/2007/ops\" xml:lang=\"ja\" class=\"" . $myTxtDirection . "\">\n<head>\n<meta charset=\"UTF-8\" />\n<title>" . $bookTitleName . "</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"../style/book-style.css\" />\n</head>\n<body class=\"p-toc\">\n<div class=\"main\">\n\n<\!-- 目次 -->\n<h1 class=\"naka-midashi\">目次見出し</h1>\n<p><br/></p>\n<p><br/></p>\n\n" . $finalTocText . "\n\n<p><a href=\"p-credit\.xhtml\">電子化クレジット</a></p>\n\n</div>\n</body>\n</html>";

#出力
$finalTocText = encode('UTF-8', $finalTocText);
print $finalTocText;

exit;
