use utf8;
#Encodeモジュールをインポート
use Encode qw/encode decode/;
use File::Basename qw/basename dirname/;

$_ = $ARGV[0];
$_ = decode('UTF-8', $_);

#指定フォルダを開く
opendir(DIRHANDLE, "$_");
my @allFileList;
foreach $file(readdir(DIRHANDLE)){
	unless ($file =~ /^(.*?)\.xhtml$/){next;};
	push @allFileList, $file;
}
#親フォルダ名を取得
my $parentDirName = basename $_;

#指定フォルダを閉じる
closedir(DIRHANDLE);

#ソート処理
@allFileList = sort {$b <=> $a} @allFileList;

#中間出力テキストリスト定義
my @pCoverList;
my @pWhiteList;
my @pHonbunList;
my @pColophonList;
my @pAdList;
my @pCreditList;
my @otherList;

#最終出力テキストリスト定義
my @finalXhtmlManifestList;

#各項目ごとに分類
for (1..scalar(@allFileList)){
	$myListFile = pop(@allFileList);
	if ($myListFile =~ /^p-cover\.xhtml$/){unshift (@pCoverList,$myListFile);
	} elsif ($myListFile =~ /^p-white-?([0-9]+)?\.xhtml$/){unshift (@pWhiteList,$myListFile);
	} elsif ($myListFile =~ /^p-[0-9]+\.xhtml$/){unshift (@pHonbunList,$myListFile);
	} elsif ($myListFile =~ /^p-colophon\.xhtml$/){unshift (@pColophonList,$myListFile);
	} elsif ($myListFile =~ /^p-ad-[0-9]+\.xhtml$/){unshift (@pAdList,$myListFile);
	} elsif ($myListFile =~ /^p-credit\.xhtml$/){unshift (@pCreditList,$myListFile);
	} else {unshift (@otherList,$myListFile);
	}
}

#p-cover（カバー）ページの置換処理
foreach $myListFile(@pCoverList){
	$myListFile =~ s@^p-cover\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"p-cover\" href=\"$parentDirName/p-cover\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}
#p-white-xxx（白紙）ページの置換処理
foreach $myListFile(@pWhiteList){
	$myListFile =~ s@^p-(white-?([0-9]+)?)\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"p-$1\" href=\"$parentDirName/p-$1\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}
#p-xxx（本文）ページの置換処理
foreach $myListFile(@pHonbunList){
	$myListFile =~ s@^p-([0-9]+)\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"p-$1\" href=\"$parentDirName/p-$1\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}
#p-colophon（原本奥付）ページの置換処理
foreach $myListFile(@pColophonList){
	$myListFile =~ s@^p-colophon\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"p-colophon\" href=\"$parentDirName/p-colophon\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}
#p-ad-xxx（広告）ページの置換処理
foreach $myListFile(@pAdList){
	$myListFile =~ s@^p-ad-([0-9]+)\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"p-ad-$1\" href=\"$parentDirName/p-ad-$1\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}
#p-credit（電子化奥付）ページの置換処理
foreach $myListFile(@pCreditList){
	$myListFile =~ s@^p-credit\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"p-credit\" href=\"$parentDirName/p-credit\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}
#それ以外のページの置換処理
foreach $myListFile(@otherList){
	$myListFile =~ s@^(.*?)\.xhtml$@<item media-type=\"application/xhtml+xml\" id=\"$1\" href=\"$parentDirName/$1\.xhtml\" properties=\"svg\" />@i;
	push (@finalXhtmlManifestList,$myListFile);
}

#@finalXhtmlManifestList;を改行コード入り文字列に
my $finalXhtmlManifestText = join("\n",@finalXhtmlManifestList);

#出力
print $finalXhtmlManifestText;